ORCA/M Asm65816 2.1.0

0001 89D4                       title ' Memory Manager' 
0002 89D4              ********************************************************************************
0003 89D4              *
0004 89D4              * Memory manager  Tool Set #2
0005 89D4              *
0006 89D4              * (C) Copyright 1985-1989,1991
0007 89D4              * Apple Computer, Inc.
0008 89D4              * All Rights Reserved
0009 89D4              *
0010 89D4              * 21-Jan-91         Dave Lyons
0011 89D4              *
0012 89D4              * Added new call $3002 SetHandleID(newID,handle):oldID.
0013 89D4              * If you pass 0 for the new ID, it just returns the old one.
0014 89D4              *
0015 89D4              * 12-Jun-91         Dave Lyons
0016 89D4              *
0017 89D4              * Added check in DisposeHandle to disallow disposing the first handle.
0018 89D4              * This would be very bad.  Now returns error $0206.
0019 89D4              *
0020 89D4              * 14-Sep-91         Dave Lyons
0021 89D4              *
0022 89D4              * Removed one instruction in CheckRecent to allow for the case that
0023 89D4              * LastLowHandle and LastHighHandle are equal, and are the handle that
0024 89D4              * we're disposing/etc.  In this case we need to bump *both* hints,
0025 89D4              * but it was only bumping the low one.
0026 89D4              *
0027 89D4              * In case anybody does another ROM, added ClearRecent to DisposeAll
0028 89D4              * and PurgeAll (this was done long ago for the ROM 1 patch).
0029 89D4              *
0030 89D4              * 19-Dec-91         Dave Lyons
0031 89D4              *
0032 89D4              * Fixed XSearchFail to correctly return CLC when we run out of retry
0033 89D4              * methods.
0034 89D4              *
0035 89D4              * It was accidentally returning SEC ("okay to try again"), and this
0036 89D4              * was causing a long hang and then a crash--we would try retry methods
0037 89D4              * number 8 through $FFFF, and then crash when we wrapped back to zero.
0038 89D4              * (This happened only if an OOMQ routine claimed to have freed up enough
0039 89D4              * memory on the *second* pass.)
0040 89D4              *
0041 89D4              ********************************************************************************
0042 89D4
0043 89D4
0044 89D4              ********************************************************************************
0045 89D4              *
0046 89D4              * SetHandleID -- set the owner ID for a handle, and return the old one
0047 89D4              *
0048 89D4              * Inputs:
0049 89D4              *   WORD  space for result (old ID)
0050 89D4              *   WORD  owner ID
0051 89D4              *   LONG  handle
0052 89D4              *
0053 89D4              * If you pass 0 for the new ID, the old ID is unchanged, and it just tells
0054 89D4              * you what the ID is.
0055 89D4              *
0056 89D4              ********************************************************************************
0057 89D4              SetHandleID proc export 
0058 89D4                       longa on
0059 89D4                       longi on
0060 89D4
0061 89D4              oldD     equ   1
0062 89D4              rtl      equ   oldD+2
0063 89D4              theHandle equ   rtl+6
0064 89D4              theNewID equ   theHandle+4
0065 89D4              theResult equ   theNewID+2
0066 89D4
0067 89D4 0B                    phd   
0068 89D5 3B                    tsc   
0069 89D6 5B                    tcd   
0070 89D7 A0 06 00              ldy   #Hndl_Owner
0071 89DA B7 09                 lda   [<theHandle],y
0072 89DC 85 0F                 sta   <theResult
0073 89DE A5 0D                 lda   <theNewID
0074 89E0 F0 02                 beq   @done
0075 89E2 97 09                 sta   [<theHandle],y
0076 89E4 2B           @done    pld   
0077 89E5 A2 00 00              ldx   #0                       ;no error
0078 89E8 A0 06 00              ldy   #6                       ;strip 6 bytes
0079 89EB 5C 84 01 E1           jml   $e10184                  ;ToStrip
0080 89EF
0081 89EF                       EndP 
0082 89EF
0083 89EF
0084 89EF              ********************************************************************************
0085 89EF              *
0086 89EF              * VerifyHandle - Veriifies that an inputted handle is a real handle
0087 89EF              *              to be valid:
0088 89EF              *              Hndl <> nil
0089 89EF              *              Hndl.prev.next = hndl or nil
0090 89EF              *              if hndl.prev.next = nil then hndl must be head of a list
0091 89EF              *
0092 89EF              * inputs:      ParmHndl = handle to check
0093 89EF              *
0094 89EF              * outputs:     Hndl = handle
0095 89EF              *              if invalid, return address popped and jumps to CleanUp
0096 89EF              *
0097 89EF              * VerifyH2 entry point from move routines Checks Z flag
0098 89EF              *
0099 89EF              ********************************************************************************
0100 89EF              VerifyHandle PROC Export 
0101 89EF                       longa on
0102 89EF                       longi on
0103 89EF
0104 89EF A5 2D                 lda   ParmHndl                 ;Get the inputted handle
0105 89F1 85 17                 sta   Hndl
0106 89F3 A5 2F                 lda   ParmHndl+2
0107 89F5 85 19                 sta   Hndl+2
0108 89F7
0109 89F7                       ENTRY VerifyH2 
0110 89F7              VerifyH2                                ;
0111 89F7 F0 4F                 beq   BadHandle                ;If 0 then no good
0112 89F9 A0 0C 00              ldy   #Hndl_Prev               ;Get the previous
0113 89FC B7 17                 lda   [hndl],y
0114 89FE 85 0F                 sta   hndl1
0115 8A00 C8                    iny   
0116 8A01 C8                    iny   
0117 8A02 B7 17                 lda   [hndl],y
0118 8A04 85 11                 sta   hndl1+2
0119 8A06 05 0F                 ora   hndl1                    ;Is there no previous?
0120 8A08 F0 25                 beq   NoPrev
0121 8A0A              ; ###
0122 8A0A              ; Mensch 11/13/89
0123 8A0A              ; Add test here to see if prev and Next are the same in Hndl
0124 8A0A              ; This will detect if a handle was "echo" of the data bank register in high RAM
0125 8A0A              ;
0126 8A0A A0 10 00              ldy   #Hndl_Next               ; get the next of the same handle...
0127 8A0D B7 17                 lda   [Hndl],y
0128 8A0F C5 0F                 cmp   Hndl1                    ; see if the low word is the same
0129 8A11 D0 0A                 bne   @passSubTest             ; if not then it passes this test...
0130 8A13 C8                    iny   
0131 8A14 C8                    iny   
0132 8A15 B7 17                 lda   [Hndl],y
0133 8A17 C5 11                 cmp   hndl1+2
0134 8A19 D0 02                 bne   @passSubTest
0135 8A1B 80 2B                 bra   BadHandle                ; else this is a bad handle...
0136 8A1D              ;
0137 8A1D              @PassSubTest  
0138 8A1D              ; ###
0139 8A1D A0 10 00              ldy   #Hndl_Next               ;Get the next of the previous
0140 8A20 B7 0F                 lda   [Hndl1],y
0141 8A22 C5 17                 cmp   Hndl                     ;Is it = hndl?
0142 8A24 D0 22                 bne   BadHandle
0143 8A26 C8                    iny   
0144 8A27 C8                    iny   
0145 8A28 B7 0F                 lda   [Hndl1],y
0146 8A2A C5 19                 cmp   Hndl+2
0147 8A2C D0 1A                 bne   BadHandle
0148 8A2E 60           HandleOK rts                            ;It was OK
0149 8A2F
0150 8A2F A2 08 00     NoPrev   ldx   #FreeList-MemList        ;Head of a list?
0151 8A32 A5 17        HeadLoop lda   hndl
0152 8A34 DF 00 16 E1           cmp   MemList,x
0153 8A38 D0 08                 bne   NotHead
0154 8A3A A5 19                 lda   hndl+2
0155 8A3C DF 02 16 E1           cmp   MemList+2,x
0156 8A40 F0 EC                 beq   HandleOK                 ;We Found it
0157 8A42 CA           NotHead  dex   
0158 8A43 CA                    dex   
0159 8A44 CA                    dex   
0160 8A45 CA                    dex   
0161 8A46 10 EA                 bpl   HeadLoop                 ;Go try next list
0162 8A48
0163 8A48 A9 06 02     BadHandle lda   #HandleErr              ;Give back error
0164 8A4B 85 01                 sta   Error
0165 8A4D 68                    pla                            ;Pop return address
0166 8A4E 5C 8C 16 E1           jmp   CleanUp
0167 8A52
0168 8A52                       ENDP 
